---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
---

# Resolution Margin (diagnostic)

> Distance to ε (under-resolution risk); how much detail can be lost before Form/diagnosis fails.

---

## Definition

- Detail preservation gap
- Clarity headroom level
- Distinction buffer size
- Resolution safety margin

---

## Dual‑register mapping

### Technical (network/computational)

| Diagnostic concept | Network construct | Test example |
|-------------------|------------------|--------------|
| Detail gap | Signal margin | `Monitor`, `Detail` |
| Clarity level | Resolution room | `Check`, `Clear` |
| Buffer size | Sample space | `Test`, `Buffer` |

### Humane (biological/relational)

| Diagnostic concept | Humane construct | Example |
|-------------------|------------------|----------|
| Detail gap | Can see fine | "Sees clearly" |
| Clarity level | Sharp enough | "Clear view" |
| Buffer size | Room to blur | "Still clear" |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| Signal margin | Can see fine | How detail works |
| Resolution room | Sharp enough | How clarity forms |
| Sample space | Room to blur | How buffer helps |

### Domain Examples

| Domain | Technical test | Humane test |
|--------|---------------|-------------|
| Physics | Measure fine | See detail |
| Networks | Data clear | Link sharp |
| Cognition | Mind sharp | Think clear |
| Systems | State fine | Flow clear |

---

## Scale Effects

How Resolution Margin manifests differently at various scales:

### Micro Scale (ε-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ε | Quantum detail | Wave fine |
| λV | Gate clear | State sharp |

### Human Scale (ψA-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ψA | Phase sharp | Pattern clear |
| ∇S | Structure fine | Clear detail |

### Cosmic Scale (c-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| c | Wave clear | Light fine |
| λV | Field sharp | Space detail |

Note: At extreme scales, resolution faces fundamental limits (e.g., quantum detail at ε, causal clarity at c).

---

## Invariants / Thresholds

Scale-dependent bounds:
- ε: detail threshold
- c: clarity limit
- ψA: phase fine
- λV: gate sharp

---

## SVA Coupling

Scale-dependent modulator effects:

| Scale | Modulator | Technical effect | Humane effect |
|-------|-----------|-----------------|---------------|
| Micro | ∇S | Pattern fine | Wave clear |
| Human | λV | Gate sharp | Flow detail |
| Cosmic | ψA | Phase clear | Field fine |

---

## Failure Modes

Scale-dependent failure patterns:

| Scale | Mode | Technical signature | Humane signature |
|-------|------|-------------------|------------------|
| Micro | Detail loss | Pattern blur | Too fuzzy |
| Human | Clarity fail | Flow blur | Can't see |
| Cosmic | Fine loss | Field blur | Lost detail |

---

## Diagnostic Checklist

Technical tests:
- [ ] Detail tracked
- [ ] Clarity held
- [ ] Buffer sized
- [ ] Fine kept

Humane tests:
- [ ] Sees fine
- [ ] Stays clear
- [ ] Room enough
- [ ] Detail good

---

## Design rationale

This diagnostic must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical resolution nor experiential clarity alone captures its full meaning.

---

## See Also

- [[Stability Margin (diagnostic)]]
- [[Capacity Margin (diagnostic)]]
- [[Phase Margin (diagnostic)]]
- [[Form]]
- [[Field]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale-aware tests documented